 ; Lin - linetype editor utility - uses acad.pgp command XXX to shell out
 ; to a text editor. Adds ".lin" to the filename if required and saves the
 ; filename as the default.
 (DEFUN C:LIN (/ fn tt len ll ch ln)
  (setvar "cmdecho" 1)
  (if (= (type linf) 'str)
      (setq tt (strcat "Linetype file <" linf ">: "))
      (setq tt "Linetype file: "))
  (setq fn (getstring T tt))
  (if (/= fn "") (setq linf fn))
  (setq ll (strlen linf))
  (while (and (< 0 ll) (/= (substr linf ll 1) (chr 92)))
         (if (= (substr linf ll 1) ".")
             (setq ch T))
         (setq ll (1- ll)))
  (if (null ch)
      (setq fn (setq linf (strcat linf ".lin")))
      (setq fn linf))
  (if (= (type linm) 'str)
      (setq tt (strcat "Linetype <" linm ">: "))
      (setq tt "Linetype: "))
  (setq ln (getstring t tt))
  (if (/= ln "") (setq linm ln))
  (command "xxx" fn)
  (if (tblsearch "ltype" linm)
      (command "linetype" "load" linm linf "" "")
      (command "linetype" "load" linm linf ""))
 (princ))